//+------------------------------------------------------------------+
//|                                       smTMMS Oscillator_v2.0.mq5 |
//|                                   Copyright 01.08.2019, SwingMan |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 01.08.2019, SwingMan"
#property link      "https://www.mql5.com"

#property indicator_separate_window

//---- indicator settings
#property indicator_buffers 5

#property indicator_plots   1

#property indicator_type1   DRAW_COLOR_HISTOGRAM
#property indicator_color1  Green,Red,Silver
#property indicator_width1  3
#property indicator_label1  "smTMMS-Histogram"

#property indicator_minimum -50
#property indicator_maximum 50
#property indicator_level1 20
#property indicator_level2 0
#property indicator_level3 -20

//--- input parameters
//+------------------------------------------------------------------+
sinput string        sRSI="RSI"; //=================================     
input int            RSI_Period=14;
input ENUM_APPLIED_PRICE      RSI_AppliedPrice=PRICE_CLOSE;
//
sinput string        sStochastic="STOCHASTIC"; //=================================    
input int            Stochastic_1_Period_K  = 8;
input int            Stochastic_1_Period_D  = 3;
input int            Stochastic_1_Slowing   = 3;
input ENUM_STO_PRICE Stochastic_1_PriceField = STO_LOWHIGH;
input ENUM_MA_METHOD Stochastic_1_MAmethod   = MODE_SMMA;
input int            Stochastic_2_Period_K  = 14;
input int            Stochastic_2_Period_D  = 3;
input int            Stochastic_2_Slowing   = 3;
input ENUM_STO_PRICE Stochastic_2_PriceField = STO_LOWHIGH;
input ENUM_MA_METHOD Stochastic_2_MAmethod   = MODE_SMMA;
//+------------------------------------------------------------------+

//--- indicator buffers
double bufRSI[];
double bufStoch1[];
double bufStoch2[];

double bufHistogram[];

double bufColors[];

//--- handles for indicators
int    handleRSI;
int    handleStoch1;
int    handleStoch2;

//--- bars minimum for calculation
#define DATA_LIMIT 33

double threshold=50;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,bufHistogram,INDICATOR_DATA);
   SetIndexBuffer(1,bufColors,INDICATOR_COLOR_INDEX);
   SetIndexBuffer(2,bufRSI,INDICATOR_CALCULATIONS);
   SetIndexBuffer(3,bufStoch1,INDICATOR_CALCULATIONS);
   SetIndexBuffer(4,bufStoch2,INDICATOR_CALCULATIONS);
//--- set accuracy
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//--- sets first bar from what index will be drawn
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,33);
//--- name for DataWindow 
   IndicatorSetString(INDICATOR_SHORTNAME,"smTMMS-Oscillator-MT5_v2.0");
//--- get handles
   handleRSI=iRSI(NULL,0,
                  RSI_Period,RSI_AppliedPrice);
   handleStoch1=iStochastic(NULL,0,
                            Stochastic_1_Period_K,Stochastic_1_Period_D,Stochastic_1_Slowing,
                            Stochastic_1_MAmethod,Stochastic_1_PriceField);
   handleStoch2=iStochastic(NULL,0,
                            Stochastic_2_Period_K,Stochastic_2_Period_D,Stochastic_2_Slowing,
                            Stochastic_2_MAmethod,Stochastic_2_PriceField);
//---
//---- initialization done
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//--- check for rates total
   if(rates_total<=DATA_LIMIT)
      return(0);// not enough bars for calculation

//--- 1. RSI =================================================
   int calculated=BarsCalculated(handleRSI);
   if(calculated<rates_total)
     {
      Print("Not all data of handleRSI is calculated (",calculated,"bars ). Error",GetLastError());
      return(0);
     }
//--- 1.1 copy RSI data     
   int to_copy;
   if(prev_calculated>rates_total || prev_calculated<0) to_copy=rates_total;
   else
     {
      to_copy=rates_total-prev_calculated;
      if(prev_calculated>0) to_copy++;
     }

//--- get RSI buffer
   if(IsStopped()) return(0); //Checking for stop flag
   if(CopyBuffer(handleRSI,0,0,to_copy,bufRSI)<=0)
     {
      Print("Getting RSI is failed! Error",GetLastError());
      return(0);
     }

//--- 2. get Stochastic-1/2 buffers ==========================
   CopyBuffer(handleStoch1,0,0,to_copy,bufStoch1);
   CopyBuffer(handleStoch2,0,0,to_copy,bufStoch2);

//--- 3. first calculation or number of bars was changed =====
   int i,limit;
   if(prev_calculated<=DATA_LIMIT)
     {
      for(i=0;i<DATA_LIMIT;i++)
         bufHistogram[i]=0.0;
      limit=DATA_LIMIT;
     }
   else limit=prev_calculated-1;

//--- 4. main loop of calculations ===========================
   double zero=0;
   for(i=limit;i<rates_total && !IsStopped();i++)
     {
      bufRSI[i]   =bufRSI[i]-threshold;
      bufStoch1[i]=bufStoch1[i]-threshold;
      bufStoch2[i]=bufStoch2[i]-threshold;

      bufHistogram[i]=bufStoch2[i];

      if(bufRSI[i]>zero && bufStoch1[i]>zero && bufStoch2[i]>zero)
         bufColors[i]=0.0;
      else
      if(bufRSI[i]<zero && bufStoch1[i]<zero && bufStoch2[i]<zero)
         bufColors[i]=1.0;
      else
         bufColors[i]=2.0;
     }

//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
